# Virtual Idea Area

Virtual reality whiteboard software for HTC Vive.

Virtual Idea Area was originally released in 2017 on Steam. Fast-forward to 2026 and there have been a lot of advancements in virtual reality hardware and the software around it. VIA has not aged gracefully, and it makes no sense to keep this increasingly incompatible software up for sale. As such the software is now free, and the source code available under the 3-Clause BSD License (see LICENSE.txt) to anyone interested.

## Build
Start by making sure all the dependencies are present:
* `OpenGL` headers: already provided but you may wish to get an updated version from the [OpenGL Registry on Github](https://github.com/KhronosGroup/OpenGL-Registry).
* `openvr`: initialize the git repository with `git init` and download as a submodule with `git submodule add https://github.com/ValveSoftware/openvr.git dep/openvr/openvr-master`. Alternatively manually download the latest release from the [OpenVR repository on Github](https://github.com/ValveSoftware/openvr/) and extract to `dep/openvr/openvr-master`.
* `stb_truetype`: already provided but you may wish to get an updated version from the [stb repository on Github](https://github.com/nothings/stb/blob/master/stb_truetype.h).
* `steamworks` SDK: only needed if you wish to enable Steam integration for some reason. Download from [Steam](https://partner.steamgames.com/doc/sdk) and place the extracted `sdk` folder into `dep/steamworks`.

After that the project can be built using [CMake](https://cmake.org/). There is only one boolean option `VIA_STEAMWORKS` which enables the Steamworks integration (who'd have guessed?).

To run the application you launch it using `rundir` as the working directory. Copy `openvr_api.dll` (and optionally `steam_api64.dll`) from the dependencies into this folder first.

If you have made any modifications to the shaders you will need to regenerate the `shaders.c` source file by running the Python script `shaders.py` in the shaders folder (the script will overwrite the existing `shaders.c` file). Similarly, for changes to `uistrings.json` you will need to run `stringsdb.py` (the resulting `.ysd` file needs to be placed in `rundir/data/ui`).

To modify the 2D UI layouts modify the `*.yud` files in the `rundir/data/ui` folder.

## Excercises for the reader
If you would like to update VIA for the modern age, here are some things to get started:

### Performance on AMD graphics cards
VIA's performance on AMD graphics cards is currently awful. The first hurdle to overcome is how extremely slow calls to `glGetTextureHandleARB` are. Most of the work to get around this (creating and caching the handle on texture creation) is in `sys_tilestore.c`. Alternatively you can hope for a driver update to magically fix it, wouldn't be the first time.

After that performance will still be bad, and figuring out why is pretty hard because graphics debuggers apparently don't like bindless textures.

### Wine/Proton
The 2D interface is fully black. Could be an easy fix but I didn't find it.

### Control scheme
VIA's controls are designed around the physical shape of a Vive controller and the fact that it has a touchpad. Modern VR controllers are nothing like that in both regards. I recommend using [OpenVR render models](https://github.com/ValveSoftware/openvr/wiki/IVRRenderModels_Overview) to solve the first problem, but the second will require some more creativity.

### OpenGL
Highly recommend using a modern API instead. Vulkan, DX12, Metal, ... whatever floats your boat.