import sys
import os

def calc_margins(i):
	foo = max(i[1],i[2])
	h = 1.0 - i[1]/foo
	v = 1.0 - i[2]/foo
	hs = '{:.3f}'.format(h/2)
	vs = '{:.3f}'.format(v/2)
	return 'il='+hs+' ir='+hs+' it='+vs+' ib='+vs
	
def make_segment(yoff, limg, rimg):
	out = '';
	y000 = str(yoff) + '.0';
	y050 = str(yoff) + '.5';
	y075 = str(yoff) + '.75';
	y150 = str(yoff+1) + '.5';
	lmg = calc_margins(limg)
	rmg = calc_margins(rimg)
	out += 'ofloor	px=0.0   py='+y000+' pz=0.002 e0x=2.0 e0y=0.0  e0z=0.0 e1x=0.0 e1y=2.0 e1z=0.0 clr=#2b4d2b\n'
	out += 'ifloor	px=0.5   py='+y050+' pz=0.003 e0x=1.0 e0y=0.0  e0z=0.0 e1x=0.0 e1y=1.0 e1z=0.0 clr=#1c201c\n'
	out += 'llwall	px=0.0   py='+y000+' pz=0.0   e0x=0.0 e0y=2.0  e0z=0.0 e1x=0.0 e1y=0.0 e1z=0.5 clr=#744325\n'
	out += 'ltwall	px=0.0   py='+y000+' pz=0.5   e0x=0.0 e0y=2.0  e0z=0.0 e1x=0.0 e1y=0.0 e1z=2.0 clr=#f7ec9c\n'
	out += 'limg	px=0.001 py='+y050+' pz=1.0   e0x=0.0 e0y=1.0  e0z=0.0 e1x=0.0 e1y=0.0 e1z=1.0 clr=#FFFFFF img="'+limg[0]+'" '+lmg+'\n'
	out += 'rimg	px=1.999 py='+y150+' pz=1.0   e0x=0.0 e0y=-1.0 e0z=0.0 e1x=0.0 e1y=0.0 e1z=1.0 clr=#FFFFFF img="'+rimg[0]+'" '+rmg+'\n'
	out += 'rlwall	px=2.0   py='+y000+' pz=0.0   e0x=0.0 e0y=2.0  e0z=0.0 e1x=0.0 e1y=0.0 e1z=0.5 clr=#744325\n'
	out += 'rtwall	px=2.0   py='+y000+' pz=0.5   e0x=0.0 e0y=2.0  e0z=0.0 e1x=0.0 e1y=0.0 e1z=2.0 clr=#f7ec9c\n'
	out += 'ceil	px=0.0   py='+y000+' pz=2.5   e0x=2.0 e0y=0.0  e0z=0.0 e1x=0.0 e1y=2.0 e1z=0.0 clr=#2b2b55\n'
	out += 'ceill	px=0.75  py='+y075+' pz=2.499 e0x=0.5 e0y=0.0  e0z=0.0 e1x=0.0 e1y=0.5 e1z=0.0 clr=#FFFFFF\n'
	return out

base = sys.argv[1]
#iterate over png files in given folder
imgs = []
for fname in os.listdir(base):
	#open file
	i = open(base + "\\" + fname, 'rb');
	#read a bit of header to check for png
	hdr = i.read(8)
	i.seek(4, 1)
	ctype = i.read(4)
	if hdr != b'\x89PNG\x0D\x0A\x1A\x0A': continue;
	if ctype != b'IHDR': continue;
	#read w and h
	w = int.from_bytes(i.read(4), 'big');
	h = int.from_bytes(i.read(4), 'big');
	i.close();
	#add to list
	imgs.append([base + "\\" + fname, w, h])
#even out list
if len(imgs)%2==1:
	imgs.append(["", 1, 1])
	
#open file
f = open('galdef.txt', 'w', encoding='utf-8')

#make segments
for i in range(0, len(imgs)//2):
	apnd = make_segment(i*2, imgs[i*2], imgs[i*2+1])
	f.write(apnd)

#done
f.close()