import os
import sys
import math
import random

def main():
	f = open('massdef.txt', 'w', encoding='utf-8')
	base = sys.argv[1]
	n = 0
	for i in range(0,8):
		for fname in os.listdir(base):
			f.write(genboard(base + '\\' + fname, n))
			n = n + 1
	f.close()

def cross(a,b):
	x = a[1]*b[2] - a[2]*b[1]
	y = a[2]*b[0] - a[0]*b[2]
	z = a[0]*b[1] - a[1]*b[0]
	return (x,y,z)
	
def norm(a):
	l = math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2])
	return (a[0]/l,a[1]/l,a[2]/l)
	
def scale(s,a):
	return (s*a[0],s*a[1],s*a[2])
	
def randdir():
	a = random.random() * 3.14159265 * 2
	x = math.cos(a)
	y = math.sin(a)
	z = random.random()**2
	return norm((x,y,z))
	
def genboard(path,i):
	dir = randdir()
	dst = 5 + i*0.1
	pos = scale(dst, dir)
	dir = norm((dir[0],dir[1],0))
	e0 = norm(cross(dir,(0,0,1)))
	e1 = cross(e0,dir)	
	e0 = scale(2, e0)
	e1 = scale(2, e1)
	sp = ' px={:.3f} py={:.3f} pz={:.3f}'.format(pos[0],pos[1],pos[2])
	se0 = ' e0x={:.3f} e0y={:.3f} e0z={:.3f}'.format(e0[0],e0[1],e0[2])
	se1 = ' e1x={:.3f} e1y={:.3f} e1z={:.3f}'.format(e1[0],e1[1],e1[2])
	sim = ' clr=#FFFFFF img="'+path+'"\n'
	return sp + se0 + se1 + sim

main()