#version 430
#define WEIGHT_R 0.299
#define WEIGHT_G 0.587
#define WEIGHT_B 0.114

uniform vec4 color_gbl;

smooth in float lum;
out vec4 out_Color;

void main(void) {
	out_Color.b = color_gbl.y;
	out_Color.g = color_gbl.x;
	out_Color.r = 1.0f - out_Color.g - out_Color.b;
	float baselum = 0.0;
	baselum += out_Color.r * WEIGHT_R;
	baselum += out_Color.g * WEIGHT_G;
	baselum += out_Color.b * WEIGHT_B;
	out_Color *= lum / baselum;
	out_Color.a = 1.0f;
}
