#version 430
#extension GL_ARB_bindless_texture : require
#define YR_ACCURACY 4096
uniform mat4 cam_mat;
uniform ivec4 cam_off;
uniform sampler2D floortex;

smooth in vec4 frag_Pos;
out vec4 out_Color;

#include "lighting.glslshared"

void main(void)
{	
	//calculate floor coordinate
	vec2 floorcoord = frag_Pos.xy / 2;
	floorcoord += mod(cam_off.xy, 2*YR_ACCURACY)/(2*YR_ACCURACY);
	
	//texture lookups and floor light calc
	vec4 floorcolor = texture(floortex, floorcoord);
	floorcolor *= light(cam_mat, vec3(0,0,1), frag_Pos+cam_off);
	out_Color = floorcolor;
}
