#version 430
#extension GL_ARB_bindless_texture : require

uniform sampler2D tex;
uniform vec4 mdl_color;
uniform mat4 cam_mat;

smooth in vec3 frag_Normal;
smooth in vec2 frag_TexCoord;
out vec4 out_Color;

#include "lighting.glslshared"

void main(void)
{
	vec3 n = normalize(frag_Normal);
	vec4 l = light_noshadow(cam_mat, n);
	vec4 foo = texture(tex, frag_TexCoord);
	float saturation = foo.r;
	float value = foo.g;
	float selfillum = foo.b;
	//foo.a is unused
	
	vec4 color = value * mix(vec4(1.0f,1.0f,1.0f,1.0f), mdl_color, saturation);
	out_Color = color * mix(l, vec4(1.0f), selfillum);
}
