#version 430
#extension GL_ARB_bindless_texture : require

uniform sampler2D overlay;
uniform mat4 cam_mat;
uniform vec3 quad_normal;
uniform float lit;

smooth in vec2 frag_TexCoord;
smooth in vec4 frag_pos;
out vec4 out_Color;

#include "lighting.glslshared"

void main(void) {
	out_Color = texture(overlay, frag_TexCoord);
	
	//lighting
	vec4 light_factor = light(cam_mat, quad_normal, frag_pos);
	out_Color *= mix(vec4(1.0), light_factor, lit);
}
