import os
import subprocess

def dumpfile(fname):
	s = open(fname, 'r')
	for line in s:
		if line[:10] == '#include "':
			dumpfile(line[10:-2])
		else:
			#[rtrim(line)]\\n\\\n
			f.write(line.rstrip().encode('utf-8'))
			f.write('\\n\\\n'.encode('utf-8'))
	s.close()

#open and write header
f = open('..\\src\\core\\shaders.c','wb')
f.write('/*This file was automatically generated by shaders.py\n'.encode('utf-8'))
f.write('/*from the .glsl files in the shaders directory.*/\n'.encode('utf-8'))
f.write('#include "ogl.h"\n\n'.encode('utf-8'))

#iterate over glsl files
exts = ['.glsl','.vert','.tesc','.tese','.geom','.frag','.comp']
for fname in os.listdir('.'):
	if not (fname[-5:] in exts):
		continue
		
	#const GLchar* [type]Shader_[fname] = "
	us = fname.find('_')
	f.write('const GLchar* '.encode('utf-8'))
	f.write(fname[0].upper().encode('utf-8'))
	f.write(fname[1:us].encode('utf-8'))
	f.write('Shader_'.encode('utf-8'))
	f.write(fname[us+1:-5].encode('utf-8'))
	f.write(' = "'.encode('utf-8'))
	dumpfile(fname)
	f.write('";\n'.encode('utf-8'))
f.close()