#version 430

uniform mat4 cam_mat;
uniform vec4 start;
uniform vec4 endoff;

layout(location=0) in vec4 vtx_Pos;

void main(void) {
	vec3 dir = normalize(endoff.xyz);
	vec3 foo = dir;
	if(abs(foo.x) > abs(foo.y))	foo.y = 1.0f;
	else						foo.x = 1.0f;
	foo = normalize(foo);

	mat4 beam_mat = mat4(0.0f);
	beam_mat[0] = vec4(normalize(cross(foo, dir)), 0.0f);
	beam_mat[1] = vec4(cross(dir, beam_mat[0].xyz), 0.0f);
	beam_mat[2] = vec4(endoff.xyz, 0.0f);
	beam_mat[3] = vec4(start.xyz, 1.0f);

	gl_Position = cam_mat * beam_mat * vtx_Pos;
}
