#version 430
#define YR_ACCURACY 4096.0f

uniform mat4 cam_mat;
uniform vec4 pos;
uniform vec4 normal;
layout(location=0) in vec3 vtx_Pos;
smooth out vec2 frag_TexCoord;

void main(void) {
	vec4 vtx = vec4(vtx_Pos.xy * 2.0 - 1.0, 0.0f, 1.0f);
	frag_TexCoord = vtx_Pos.xy;

	vec3 foo = normal.xyz;
	if(abs(foo.x) > abs(foo.y))	foo.y = 1.0f;
	else						foo.x = 1.0f;
	foo = normalize(foo);

	mat4 cap_mat = mat4(0.0f);
	cap_mat[0] = vec4(normalize(cross(foo, normal.xyz)), 0.0f);
	cap_mat[1] = vec4(cross(normal.xyz, cap_mat[0].xyz), 0.0f);
	cap_mat[2] = vec4(normal.xyz, 0.0f);
	cap_mat[3] = vec4(pos.xyz + 0.002 * normal.xyz, 1.0f);

	vtx.x *= 0.03f;
	vtx.y *= 0.03f;
	gl_Position = cam_mat * cap_mat * vtx;
}
