#version 430

uniform mat4 cam_mat;
uniform mat4 pick_mat;
uniform vec4 color_gbl;
layout(location=0) in vec3 vtx_Pos;
smooth out float lum;

void main(void) {
	vec4 pos = vec4(vtx_Pos, 1.0);
	pos.x *= 0.04;
	pos.x += 0.26;
	pos.y *= 0.25 * 0.8660254037844386;
	gl_Position = cam_mat * pick_mat * pos;
	
	lum = 1.1 * vtx_Pos.y;
}
