#version 430

uniform vec2 pos;
uniform vec4 box;
uniform vec2 outsize;
uniform vec2 charsize;

layout(location=0) in vec2 vtx_Pos;
smooth out vec2 uv;

void main(void) {
	//vertex position
	vec2 foo = pos + mix(box.xy, box.zw, vtx_Pos);
	foo = floor(foo)/outsize; //snap to pixel, then partially convert to viewport space
	foo = foo * 2 - 1.0; //finish conversion to vp space
	gl_Position = vec4(foo, 0.0, 1.0);
	//texture coordinates
	uv = vtx_Pos * (box.zw - box.xy)/charsize;
}
