#version 430
#define YR_ACCURACY 4096.0f

uniform mat4 cam_mat;
uniform ivec4 cam_pos;
uniform mat4 mdl_mat;
uniform ivec4 mdl_pos;

layout(location=0) in vec3 vtx_Pos;
layout(location=1) in vec3 vtx_Normal;
layout(location=2) in vec2 vtx_TexCoord;

smooth out vec3 frag_Normal;
smooth out vec2 frag_TexCoord;

void main(void) {
	vec4 pos_off = vec4(mdl_pos - cam_pos)/YR_ACCURACY;
	gl_Position = cam_mat * ((mdl_mat * vec4(vtx_Pos,1.0f)) + pos_off);
	frag_TexCoord = vtx_TexCoord;
	frag_Normal = (mdl_mat * vec4(vtx_Normal, 0.0f)).xyz;
}
