#version 430
#define YR_ACCURACY 4096.0f

uniform mat4 cam_mat;
uniform ivec4 cam_pos;
layout(location=0) in ivec3 vtx_Pos;
layout(location=1) in vec2 vtx_TexCoord;
smooth out vec2 frag_TexCoord;
smooth out vec4 frag_pos;

void main(void) {
	frag_pos = (vec4(ivec4(vtx_Pos,YR_ACCURACY) - cam_pos)/YR_ACCURACY);
	gl_Position = cam_mat * frag_pos;
	frag_TexCoord = vtx_TexCoord / 8;
}
