#version 430
#define YR_ACCURACY 4096.0f
#define UV_PER_METER (1.0f/0.256f)
#extension GL_ARB_bindless_texture : require

#include "ssbo_quad.glslshared"

uniform mat4 cam_mat;
uniform ivec4 cam_pos;

layout(location=0) in vec2 vtx_Pos;
layout(std430, binding=0) buffer QuadData
{
	ssbo_quad	quad[8192];
	uint		texbase[8192];
	uvec2		texbuf[];
};
layout(std430, binding=1) buffer Backgrounds
{
	uvec2		backgrounds[];
};

flat out int instance;
smooth out vec2 frag_uv;
smooth out vec4 frag_pos;

void main(void)
{
	instance = gl_InstanceID;
	frag_uv = vtx_Pos;
	ivec4 pos = quad[gl_InstanceID].v[0];
	pos += int(vtx_Pos.x) * (quad[gl_InstanceID].v[1] - quad[gl_InstanceID].v[0]);
	pos += int(vtx_Pos.y) * (quad[gl_InstanceID].v[2] - quad[gl_InstanceID].v[0]);
	pos -= cam_pos;
	frag_pos = vec4(pos)/YR_ACCURACY;
	gl_Position = cam_mat * frag_pos;
}
