#version 430

uniform mat4 cam_mat;
uniform vec4 start;
uniform vec4 initial_v;
uniform float max_t;
layout(location=0) in vec3 vtx_Pos;

void main(void) {
	float t = vtx_Pos.z * abs(max_t);
	vec4 g = vec4(0.0, 0.0, 9.81, 0.0);

	vec4 pos = start + t*initial_v - t*t*g; 

	vec3 dir = normalize((initial_v - t*g).xyz);
	vec3 side = cross(initial_v.xyz, vec3(0,0,1));
	if(dot(side,side)<0.0001) side = vec3(0,1,0);
	side = normalize(side);
	pos = pos + vec4(mat3(side, cross(side,dir), dir) * vec3(vtx_Pos.xy, 0.0), 0.0);

	gl_Position = cam_mat * pos;
}
