#version 430
#define YR_ACCURACY 4096.0f

uniform mat4 cam_mat;
uniform mat4 tracked_mat;
layout(location=0) in vec3 vtx_Pos;
smooth out vec2 frag_TexCoord;

void main(void) {
	vec4 pos = vec4(
		vtx_Pos.x * 0.04 - 0.02,
		vtx_Pos.y * 0.004 - 0.002 + 0.01,
		vtx_Pos.y * -0.04 + 0.02 + 0.049,
		1.0);
	gl_Position = cam_mat * tracked_mat * pos;
	frag_TexCoord = vtx_Pos.xy;
}
