#include "ogl.h"
#include "string.h"
#include "sys_log.h"
#ifdef _WIN32
#define strdup _strdup
#endif

int OpenGL_shader(GLuint prog, GLenum type, const GLchar* source)
{
	GLint compilestatus;
	GLchar compilelog[2048];

	GLuint shader = glCreateShader(type);
	glShaderSource(shader, 1, &source, NULL);
	glCompileShader(shader);
	glGetShaderiv(shader, GL_COMPILE_STATUS, &compilestatus);
	if(compilestatus == GL_FALSE) {
		glGetShaderInfoLog(shader, 2048, NULL, compilelog);
		yrLog(1, "Shader error log:\n%s", compilelog);
		return -1;
	}
	glAttachShader(prog, shader);
	glDeleteShader(shader);
	return 0;
}