#pragma once
#include <stdint.h>
#include <assert.h>

#ifdef _DEBUG
#define YR_ASSERT(expr) assert(expr);
#else
#define YR_ASSERT(expr) ;
#endif
typedef void* yrWindow;
typedef void* yrThread;
typedef void(*yr_threadfunc)(void*);
typedef void(*yr_windowfunc_mouse)(void* id, int x, int y);
typedef void(*yr_windowfunc_keyevent)(void* id, unsigned code, int down);
typedef void(*yr_windowfunc_resize)(void* id, unsigned w, unsigned h);
typedef void(*yr_windowfunc_char)(void* id, unsigned c);
typedef void* yrEvent;
typedef void* yrLock;
typedef void* yrFile;

typedef enum { maPlayPause, maStop, maNext, maPrev, maVolumeUp, maVolumeDown, maMute, ma_end} media_action;

void		yr_msgbox(const char* msg, ...);
int			yr_platform_update(void);
uint64_t	yr_get_microtime(void);
uint64_t	yr_get_timestamp(void);
char*		yr_timestamp_to_timestring(uint64_t ts);
char*		yr_timestamp_to_datestring(uint64_t ts);
void		yr_media_action(media_action ma);
void		yr_sleep(uint64_t time_us);
void		yr_get_real_time(unsigned* year, unsigned* month, unsigned* day, unsigned* h, unsigned* m, unsigned* s, unsigned* ms);

int			yr_path_exists(const char* path);
int			yr_delete_file(const char* filepath);
int			yr_create_directory(const char* path);

yrWindow	yrWindow_create(unsigned client_w, unsigned client_h,
							unsigned min_w, unsigned min_h,
							void* id,
							yr_windowfunc_mouse wf_m,
							yr_windowfunc_keyevent wf_ke,
							yr_windowfunc_resize wf_r,
							yr_windowfunc_char wf_c);
void		yrWindow_destroy(yrWindow wnd);
void		yrWindow_swapbuffers(yrWindow wnd);
void		yrWindow_set_title(yrWindow wnd, const char* txt);
void		yrWindow_caret_enable(yrWindow wnd, int enabled);
void		yrWindow_caret_move(yrWindow wnd, int x, int y);
void		yrWindow_caret_resize(yrWindow wnd, int w, int h);
void		yrWindow_get_placement(yrWindow wnd, size_t* len, void** data);
void		yrWindow_set_placement(yrWindow wnd, size_t len, void* data, unsigned* new_w, unsigned* new_h);

yrThread	yrThread_create(yr_threadfunc func, void* param);
int			yrThread_join(yrThread t, uint64_t time_us);
yrEvent		yrEvent_create(void);
void		yrEvent_destroy(yrEvent e);
void		yrEvent_set(yrEvent e, int state);
int			yrEvent_wait(yrEvent e, uint64_t time_us);
yrLock		yrLock_create(void);
void		yrLock_destroy(yrLock l);
void		yrLock_aqcuire(yrLock l);
void		yrLock_release(yrLock l);

#define yrF_read 1
#define yrF_write 2
#define yrF_create 4
#define yrF_seekset 1
#define yrF_seekcur 2
#define yrF_seekend 3
#define yrFDlgID_Generic 0
#define yrFDlgID_Scene 1
#define yrFDlgID_Export 2
#define yrFDlgID_Import 3
#define yrFDlgID_Backgrounds 4
char*	yrFile_path_localdata(void);
char*	yrFile_path_dialog(int dialogid, int issavedlg, int isfolderdlg, unsigned filter_count, const char** filter_names, const char** filter_specs, const char* default_ext);
int		yrFile_get_filemeta(const char* name, int64_t* size, char** time_created, char** time_modified);
yrFile	yrFile_open(const char* name, unsigned flags);
int		yrFile_close(yrFile f);
int64_t	yrFile_read(yrFile f, int64_t len, void* buf);
int64_t	yrFile_write(yrFile f, int64_t len, void* buf);
int64_t	yrFile_seek(yrFile f, int64_t pos, unsigned mode);