#pragma once
#include <stdint.h>

struct yr_quad_exporter;
typedef struct yr_quad_exporter yrQuadExporter;

enum QEColor { qecOriginal, qecTransparent, qecWhite };
enum QEStatus { qesBusy, qesInitFailed, qesFailed, qesFinished, qesCancelled, qes_end};
yrQuadExporter*	yrQuadExport_init(const char* file, const char* folder, float range, enum QEColor bgcolor, int bgimage);
enum QEStatus	yrQuadExport_status(yrQuadExporter* e, size_t* total, size_t* processed, size_t* exported, size_t* ignored, size_t* failed);
void			yrQuadExport_cancel(yrQuadExporter* e);
void			yrQuadExport_destroy(yrQuadExporter* e);

#define ERRIMP_GENERIC (-1)
#define ERRIMP_FILE (-2)
#define ERRIMP_MEM (-3)
int	yrQuadImport_single(const char* scenefile, const char* image, unsigned target_w, unsigned target_h);
int	yrQuadImport_multi(const char* scenefile, const char* importfile);