#pragma once
#include <stdint.h>
 
struct _yrtag_SceneFile;
typedef struct _yrtag_SceneFile yrSceneFile;
struct _yrtag_StReadHandle;
typedef struct _yrtag_ReadHandle yrReadHandle;
struct _yrtag_WriteHandle;
typedef struct _yrtag_WriteHandle yrWriteHandle;

yrSceneFile*	yrSceneFile_open(const char* fname, int overwrite);
int				yrSceneFile_isvalid(const char* fname);
void			yrSceneFile_close(yrSceneFile* sf);

int				yrSceneFile_backgrounds_get(yrSceneFile* sf, unsigned* count, size_t** bgsize, void** blob, uint32_t* lastid, uint32_t* idmap);
int				yrSceneFile_backgrounds_set(yrSceneFile* sf, unsigned count, size_t* bgsize, void** bgblob, uint32_t lastid, uint32_t* idmap);

yrReadHandle*	yrSFRead_static_start(yrSceneFile* sf);
yrReadHandle*	yrSFRead_start(yrSceneFile* sf);
size_t			yrSFRead_read(yrReadHandle* h, size_t len, void* buf);
void			yrSFRead_end(yrReadHandle* h);
int				yrSFRead_seek(yrReadHandle* h, int64_t pos, int relative);

yrWriteHandle*	yrSFWrite_start(yrSceneFile* sf, size_t prewrite);
size_t			yrSFWrite_write(yrWriteHandle* h, size_t len, void* buf);
int				yrSFWrite_static_end(yrWriteHandle* h);
int				yrSFWrite_end(yrWriteHandle* h, void* prewrite_data);
void			yrSFWrite_abort(yrWriteHandle* h);
size_t			yrSFWrite_copy(yrWriteHandle* h, yrReadHandle* src, size_t len);
int64_t			yrSFWrite_getptr(yrWriteHandle* h);

int				yrSFTile_exists(yrSceneFile* sf, uint32_t tile);
int				yrSFTile_delete(yrSceneFile* sf, uint32_t tile);
int				yrSFTile_read(yrSceneFile* sf, uint32_t tile, size_t* len, void** buf);
int				yrSFTile_write(yrSceneFile* sf, uint32_t tile, size_t len, void* buf);