/*This file was automatically generated by shaders.py
/*from the .glsl files in the shaders directory.*/
#include "ogl.h"

const GLchar* FragShader_barstat = "#version 430\n\
\n\
uniform vec4 color;\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	out_Color = color;\n\
}\n\
";
const GLchar* FragShader_beam = "#version 430\n\
\n\
uniform vec4 color;\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	out_Color = color;\n\
}\n\
";
const GLchar* FragShader_beamcap = "#version 430\n\
\n\
uniform sampler2D tex_Sprite;\n\
uniform vec4 color;\n\
\n\
smooth in vec2 frag_TexCoord;\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	out_Color = color * texture(tex_Sprite, frag_TexCoord);\n\
}\n\
";
const GLchar* FragShader_colorpick_lum = "#version 430\n\
#define WEIGHT_R 0.299\n\
#define WEIGHT_G 0.587\n\
#define WEIGHT_B 0.114\n\
\n\
uniform vec4 color_gbl;\n\
\n\
smooth in float lum;\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	out_Color.b = color_gbl.y;\n\
	out_Color.g = color_gbl.x;\n\
	out_Color.r = 1.0f - out_Color.g - out_Color.b;\n\
	float baselum = 0.0;\n\
	baselum += out_Color.r * WEIGHT_R;\n\
	baselum += out_Color.g * WEIGHT_G;\n\
	baselum += out_Color.b * WEIGHT_B;\n\
	out_Color *= lum / baselum;\n\
	out_Color.a = 1.0f;\n\
}\n\
";
const GLchar* FragShader_colorpick_rgb = "#version 430\n\
#define WEIGHT_R 0.299\n\
#define WEIGHT_G 0.587\n\
#define WEIGHT_B 0.114\n\
\n\
uniform vec4 color_gbl;\n\
\n\
smooth in vec4 bary;\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	float baselum = 0.0;\n\
	baselum += bary.r * WEIGHT_R;\n\
	baselum += bary.g * WEIGHT_G;\n\
	baselum += bary.b * WEIGHT_B;\n\
	float boost = color_gbl.z / baselum;\n\
	out_Color.r = bary.r * boost;\n\
	out_Color.g = bary.g * boost;\n\
	out_Color.b = bary.b * boost;\n\
	out_Color.a = 1.0f;\n\
}\n\
";
const GLchar* FragShader_floor = "#version 430\n\
#extension GL_ARB_bindless_texture : require\n\
#define YR_ACCURACY 4096\n\
uniform mat4 cam_mat;\n\
uniform ivec4 cam_off;\n\
uniform sampler2D floortex;\n\
\n\
smooth in vec4 frag_Pos;\n\
out vec4 out_Color;\n\
\n\
#define MAX_LIGHTS 2\n\
#define MAX_TRACKED 2\n\
#define TRACKED_SHADOW_SIZE 0.3\n\
\n\
uniform ivec2 light_screensize;\n\
uniform vec4 light_dir[MAX_LIGHTS];\n\
uniform vec4 light_color[MAX_LIGHTS];\n\
uniform vec4 light_trackedpos[MAX_TRACKED];\n\
uniform uvec2 light_map[MAX_LIGHTS * MAX_TRACKED];\n\
\n\
vec3 viewdir_from_screenpos(mat4 mat)\n\
{\n\
	mat4 invmat = inverse(cam_mat);\n\
	vec2 screenpos = gl_FragCoord.xy / vec2(light_screensize/2) - 1;\n\
	vec4 origin = invmat * vec4(screenpos, 0.25, 1.0);\n\
	vec4 lookat = invmat * vec4(screenpos, 0.5, 1.0);\n\
	origin = origin/origin.w;\n\
	lookat = lookat/lookat.w;\n\
	return normalize((lookat - origin).xyz);\n\
}\n\
\n\
float singlelight(vec3 e, vec3 n, vec3 l)\n\
{\n\
	vec3 h = normalize(e+l);\n\
	float diff = 0.2 / 3.1415926535897932;\n\
	float spec = 0.5 * (2+1)/(3.1415926535897932);\n\
	float facing = ((dot(n,l) * dot(n,e)) > 0.0) ? 1.0 : 0.0;\n\
	float intensity = diff + spec * pow(dot(n,h),2);\n\
	return facing * abs(dot(n,l)) * intensity;\n\
}\n\
\n\
float shadow(vec4 pos, mat4 mat, uvec2 map)\n\
{\n\
	vec4 lpos = mat * pos;\n\
	float obstruct = texture(sampler2D(map), lpos.xy/2 + 0.5).r;\n\
	float depth = lpos.z/2 + 0.5;\n\
	if(obstruct >= 1.0) obstruct = depth;\n\
	return (depth <= obstruct) ? 1.0 : 0.0;\n\
}\n\
\n\
float rand(vec4 pos, float t) {\n\
  return fract(sin(dot(pos.xy + vec2(pos.z,t) ,vec2(12.9898,78.233))) * 43758.5453);\n\
}\n\
\n\
vec4 light(mat4 viewmat, vec3 n, vec4 pos)\n\
{\n\
	vec3 base = vec3(0.3);\n\
	vec3 e = -viewdir_from_screenpos(viewmat);\n\
\n\
	vec3 total = base;\n\
	//unrolled: for(uint l = 0; l < MAX_LIGHTS; ++l) {\n\
\n\
	//light 0\n\
		//shadowmaps\n\
		float shadowtotal = 1.0;\n\
		mat4 mat;\n\
		mat[2] = light_dir[0];\n\
		mat[0] = vec4(normalize(cross(light_dir[0].xyz, vec3(1,0,0))), 0.0);\n\
		mat[1] = vec4(cross(mat[0].xyz, mat[2].xyz), 0.0);\n\
		mat[0] *= TRACKED_SHADOW_SIZE;\n\
		mat[1] *= TRACKED_SHADOW_SIZE;\n\
		mat[2] *= 2*TRACKED_SHADOW_SIZE;\n\
		// unrolled: for(uint t = 0; t < MAX_TRACKED; ++t) {\n\
		mat[3] = light_trackedpos[0] - TRACKED_SHADOW_SIZE * light_dir[0];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[0]);\n\
		mat[3] = light_trackedpos[1] - TRACKED_SHADOW_SIZE * light_dir[0];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[1]);\n\
		//light\n\
		total += light_color[0].rgb * shadowtotal * singlelight(e, n, -light_dir[0].xyz);\n\
\n\
	//light 1\n\
		//shadowmaps\n\
		shadowtotal = 1.0;\n\
		mat[2] = light_dir[1];\n\
		mat[0] = vec4(normalize(cross(light_dir[1].xyz, vec3(1,0,0))), 0.0);\n\
		mat[1] = vec4(cross(mat[0].xyz, mat[2].xyz), 0.0);\n\
		mat[0] *= TRACKED_SHADOW_SIZE;\n\
		mat[1] *= TRACKED_SHADOW_SIZE;\n\
		mat[2] *= 2*TRACKED_SHADOW_SIZE;\n\
		// unrolled: for(uint t = 0; t < MAX_TRACKED; ++t) {\n\
		mat[3] = light_trackedpos[0] - TRACKED_SHADOW_SIZE * light_dir[1];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[2]);\n\
		mat[3] = light_trackedpos[1] - TRACKED_SHADOW_SIZE * light_dir[1];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[3]);\n\
		//light\n\
		total += light_color[1].rgb * shadowtotal * singlelight(e, n, -light_dir[1].xyz);\n\
\n\
	//dither to reduce banding\n\
	total += vec3(rand(pos,viewmat[0][1]))/255;\n\
	return vec4(total, 1.0);\n\
}\n\
\n\
vec4 light_noshadow(mat4 viewmat, vec3 n)\n\
{\n\
	vec3 base = vec3(0.3);\n\
	vec3 e = -viewdir_from_screenpos(viewmat);\n\
\n\
	vec3 total = base;\n\
	for(uint l = 0; l < MAX_LIGHTS; ++l) {\n\
		//light\n\
		total += light_color[l].rgb * singlelight(e, n, -light_dir[l].xyz);\n\
	}\n\
	return vec4(total, 1.0);\n\
}\n\
\n\
void main(void)\n\
{\n\
	//calculate floor coordinate\n\
	vec2 floorcoord = frag_Pos.xy / 2;\n\
	floorcoord += mod(cam_off.xy, 2*YR_ACCURACY)/(2*YR_ACCURACY);\n\
\n\
	//texture lookups and floor light calc\n\
	vec4 floorcolor = texture(floortex, floorcoord);\n\
	floorcolor *= light(cam_mat, vec3(0,0,1), frag_Pos+cam_off);\n\
	out_Color = floorcolor;\n\
}\n\
";
const GLchar* FragShader_fontrender = "#version 430\n\
\n\
uniform sampler2D tex;\n\
smooth in vec2 uv;\n\
\n\
out vec4 out_Color;\n\
\n\
void main(void)\n\
{\n\
	out_Color = vec4(texture(tex, uv).r);\n\
}\n\
";
const GLchar* FragShader_model = "#version 430\n\
#extension GL_ARB_bindless_texture : require\n\
\n\
uniform sampler2D tex;\n\
uniform vec4 mdl_color;\n\
uniform mat4 cam_mat;\n\
\n\
smooth in vec3 frag_Normal;\n\
smooth in vec2 frag_TexCoord;\n\
out vec4 out_Color;\n\
\n\
#define MAX_LIGHTS 2\n\
#define MAX_TRACKED 2\n\
#define TRACKED_SHADOW_SIZE 0.3\n\
\n\
uniform ivec2 light_screensize;\n\
uniform vec4 light_dir[MAX_LIGHTS];\n\
uniform vec4 light_color[MAX_LIGHTS];\n\
uniform vec4 light_trackedpos[MAX_TRACKED];\n\
uniform uvec2 light_map[MAX_LIGHTS * MAX_TRACKED];\n\
\n\
vec3 viewdir_from_screenpos(mat4 mat)\n\
{\n\
	mat4 invmat = inverse(cam_mat);\n\
	vec2 screenpos = gl_FragCoord.xy / vec2(light_screensize/2) - 1;\n\
	vec4 origin = invmat * vec4(screenpos, 0.25, 1.0);\n\
	vec4 lookat = invmat * vec4(screenpos, 0.5, 1.0);\n\
	origin = origin/origin.w;\n\
	lookat = lookat/lookat.w;\n\
	return normalize((lookat - origin).xyz);\n\
}\n\
\n\
float singlelight(vec3 e, vec3 n, vec3 l)\n\
{\n\
	vec3 h = normalize(e+l);\n\
	float diff = 0.2 / 3.1415926535897932;\n\
	float spec = 0.5 * (2+1)/(3.1415926535897932);\n\
	float facing = ((dot(n,l) * dot(n,e)) > 0.0) ? 1.0 : 0.0;\n\
	float intensity = diff + spec * pow(dot(n,h),2);\n\
	return facing * abs(dot(n,l)) * intensity;\n\
}\n\
\n\
float shadow(vec4 pos, mat4 mat, uvec2 map)\n\
{\n\
	vec4 lpos = mat * pos;\n\
	float obstruct = texture(sampler2D(map), lpos.xy/2 + 0.5).r;\n\
	float depth = lpos.z/2 + 0.5;\n\
	if(obstruct >= 1.0) obstruct = depth;\n\
	return (depth <= obstruct) ? 1.0 : 0.0;\n\
}\n\
\n\
float rand(vec4 pos, float t) {\n\
  return fract(sin(dot(pos.xy + vec2(pos.z,t) ,vec2(12.9898,78.233))) * 43758.5453);\n\
}\n\
\n\
vec4 light(mat4 viewmat, vec3 n, vec4 pos)\n\
{\n\
	vec3 base = vec3(0.3);\n\
	vec3 e = -viewdir_from_screenpos(viewmat);\n\
\n\
	vec3 total = base;\n\
	//unrolled: for(uint l = 0; l < MAX_LIGHTS; ++l) {\n\
\n\
	//light 0\n\
		//shadowmaps\n\
		float shadowtotal = 1.0;\n\
		mat4 mat;\n\
		mat[2] = light_dir[0];\n\
		mat[0] = vec4(normalize(cross(light_dir[0].xyz, vec3(1,0,0))), 0.0);\n\
		mat[1] = vec4(cross(mat[0].xyz, mat[2].xyz), 0.0);\n\
		mat[0] *= TRACKED_SHADOW_SIZE;\n\
		mat[1] *= TRACKED_SHADOW_SIZE;\n\
		mat[2] *= 2*TRACKED_SHADOW_SIZE;\n\
		// unrolled: for(uint t = 0; t < MAX_TRACKED; ++t) {\n\
		mat[3] = light_trackedpos[0] - TRACKED_SHADOW_SIZE * light_dir[0];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[0]);\n\
		mat[3] = light_trackedpos[1] - TRACKED_SHADOW_SIZE * light_dir[0];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[1]);\n\
		//light\n\
		total += light_color[0].rgb * shadowtotal * singlelight(e, n, -light_dir[0].xyz);\n\
\n\
	//light 1\n\
		//shadowmaps\n\
		shadowtotal = 1.0;\n\
		mat[2] = light_dir[1];\n\
		mat[0] = vec4(normalize(cross(light_dir[1].xyz, vec3(1,0,0))), 0.0);\n\
		mat[1] = vec4(cross(mat[0].xyz, mat[2].xyz), 0.0);\n\
		mat[0] *= TRACKED_SHADOW_SIZE;\n\
		mat[1] *= TRACKED_SHADOW_SIZE;\n\
		mat[2] *= 2*TRACKED_SHADOW_SIZE;\n\
		// unrolled: for(uint t = 0; t < MAX_TRACKED; ++t) {\n\
		mat[3] = light_trackedpos[0] - TRACKED_SHADOW_SIZE * light_dir[1];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[2]);\n\
		mat[3] = light_trackedpos[1] - TRACKED_SHADOW_SIZE * light_dir[1];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[3]);\n\
		//light\n\
		total += light_color[1].rgb * shadowtotal * singlelight(e, n, -light_dir[1].xyz);\n\
\n\
	//dither to reduce banding\n\
	total += vec3(rand(pos,viewmat[0][1]))/255;\n\
	return vec4(total, 1.0);\n\
}\n\
\n\
vec4 light_noshadow(mat4 viewmat, vec3 n)\n\
{\n\
	vec3 base = vec3(0.3);\n\
	vec3 e = -viewdir_from_screenpos(viewmat);\n\
\n\
	vec3 total = base;\n\
	for(uint l = 0; l < MAX_LIGHTS; ++l) {\n\
		//light\n\
		total += light_color[l].rgb * singlelight(e, n, -light_dir[l].xyz);\n\
	}\n\
	return vec4(total, 1.0);\n\
}\n\
\n\
void main(void)\n\
{\n\
	vec3 n = normalize(frag_Normal);\n\
	vec4 l = light_noshadow(cam_mat, n);\n\
	vec4 foo = texture(tex, frag_TexCoord);\n\
	float saturation = foo.r;\n\
	float value = foo.g;\n\
	float selfillum = foo.b;\n\
	//foo.a is unused\n\
\n\
	vec4 color = value * mix(vec4(1.0f,1.0f,1.0f,1.0f), mdl_color, saturation);\n\
	out_Color = color * mix(l, vec4(1.0f), selfillum);\n\
}\n\
";
const GLchar* FragShader_overlay_draw = "#version 430\n\
\n\
uniform sampler2D brush;\n\
uniform vec4 color;\n\
\n\
smooth in vec2 uv;\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	out_Color = color.a * vec4(color.rgb, 1.0f) * texture(brush, uv);\n\
}\n\
";
const GLchar* FragShader_overlay_erase = "#version 430\n\
\n\
uniform vec3 color;\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	out_Color = vec4(color,1.0);\n\
}\n\
";
const GLchar* FragShader_overlay_render = "#version 430\n\
#extension GL_ARB_bindless_texture : require\n\
\n\
uniform sampler2D overlay;\n\
uniform mat4 cam_mat;\n\
uniform vec3 quad_normal;\n\
uniform float lit;\n\
\n\
smooth in vec2 frag_TexCoord;\n\
smooth in vec4 frag_pos;\n\
out vec4 out_Color;\n\
\n\
#define MAX_LIGHTS 2\n\
#define MAX_TRACKED 2\n\
#define TRACKED_SHADOW_SIZE 0.3\n\
\n\
uniform ivec2 light_screensize;\n\
uniform vec4 light_dir[MAX_LIGHTS];\n\
uniform vec4 light_color[MAX_LIGHTS];\n\
uniform vec4 light_trackedpos[MAX_TRACKED];\n\
uniform uvec2 light_map[MAX_LIGHTS * MAX_TRACKED];\n\
\n\
vec3 viewdir_from_screenpos(mat4 mat)\n\
{\n\
	mat4 invmat = inverse(cam_mat);\n\
	vec2 screenpos = gl_FragCoord.xy / vec2(light_screensize/2) - 1;\n\
	vec4 origin = invmat * vec4(screenpos, 0.25, 1.0);\n\
	vec4 lookat = invmat * vec4(screenpos, 0.5, 1.0);\n\
	origin = origin/origin.w;\n\
	lookat = lookat/lookat.w;\n\
	return normalize((lookat - origin).xyz);\n\
}\n\
\n\
float singlelight(vec3 e, vec3 n, vec3 l)\n\
{\n\
	vec3 h = normalize(e+l);\n\
	float diff = 0.2 / 3.1415926535897932;\n\
	float spec = 0.5 * (2+1)/(3.1415926535897932);\n\
	float facing = ((dot(n,l) * dot(n,e)) > 0.0) ? 1.0 : 0.0;\n\
	float intensity = diff + spec * pow(dot(n,h),2);\n\
	return facing * abs(dot(n,l)) * intensity;\n\
}\n\
\n\
float shadow(vec4 pos, mat4 mat, uvec2 map)\n\
{\n\
	vec4 lpos = mat * pos;\n\
	float obstruct = texture(sampler2D(map), lpos.xy/2 + 0.5).r;\n\
	float depth = lpos.z/2 + 0.5;\n\
	if(obstruct >= 1.0) obstruct = depth;\n\
	return (depth <= obstruct) ? 1.0 : 0.0;\n\
}\n\
\n\
float rand(vec4 pos, float t) {\n\
  return fract(sin(dot(pos.xy + vec2(pos.z,t) ,vec2(12.9898,78.233))) * 43758.5453);\n\
}\n\
\n\
vec4 light(mat4 viewmat, vec3 n, vec4 pos)\n\
{\n\
	vec3 base = vec3(0.3);\n\
	vec3 e = -viewdir_from_screenpos(viewmat);\n\
\n\
	vec3 total = base;\n\
	//unrolled: for(uint l = 0; l < MAX_LIGHTS; ++l) {\n\
\n\
	//light 0\n\
		//shadowmaps\n\
		float shadowtotal = 1.0;\n\
		mat4 mat;\n\
		mat[2] = light_dir[0];\n\
		mat[0] = vec4(normalize(cross(light_dir[0].xyz, vec3(1,0,0))), 0.0);\n\
		mat[1] = vec4(cross(mat[0].xyz, mat[2].xyz), 0.0);\n\
		mat[0] *= TRACKED_SHADOW_SIZE;\n\
		mat[1] *= TRACKED_SHADOW_SIZE;\n\
		mat[2] *= 2*TRACKED_SHADOW_SIZE;\n\
		// unrolled: for(uint t = 0; t < MAX_TRACKED; ++t) {\n\
		mat[3] = light_trackedpos[0] - TRACKED_SHADOW_SIZE * light_dir[0];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[0]);\n\
		mat[3] = light_trackedpos[1] - TRACKED_SHADOW_SIZE * light_dir[0];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[1]);\n\
		//light\n\
		total += light_color[0].rgb * shadowtotal * singlelight(e, n, -light_dir[0].xyz);\n\
\n\
	//light 1\n\
		//shadowmaps\n\
		shadowtotal = 1.0;\n\
		mat[2] = light_dir[1];\n\
		mat[0] = vec4(normalize(cross(light_dir[1].xyz, vec3(1,0,0))), 0.0);\n\
		mat[1] = vec4(cross(mat[0].xyz, mat[2].xyz), 0.0);\n\
		mat[0] *= TRACKED_SHADOW_SIZE;\n\
		mat[1] *= TRACKED_SHADOW_SIZE;\n\
		mat[2] *= 2*TRACKED_SHADOW_SIZE;\n\
		// unrolled: for(uint t = 0; t < MAX_TRACKED; ++t) {\n\
		mat[3] = light_trackedpos[0] - TRACKED_SHADOW_SIZE * light_dir[1];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[2]);\n\
		mat[3] = light_trackedpos[1] - TRACKED_SHADOW_SIZE * light_dir[1];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[3]);\n\
		//light\n\
		total += light_color[1].rgb * shadowtotal * singlelight(e, n, -light_dir[1].xyz);\n\
\n\
	//dither to reduce banding\n\
	total += vec3(rand(pos,viewmat[0][1]))/255;\n\
	return vec4(total, 1.0);\n\
}\n\
\n\
vec4 light_noshadow(mat4 viewmat, vec3 n)\n\
{\n\
	vec3 base = vec3(0.3);\n\
	vec3 e = -viewdir_from_screenpos(viewmat);\n\
\n\
	vec3 total = base;\n\
	for(uint l = 0; l < MAX_LIGHTS; ++l) {\n\
		//light\n\
		total += light_color[l].rgb * singlelight(e, n, -light_dir[l].xyz);\n\
	}\n\
	return vec4(total, 1.0);\n\
}\n\
\n\
void main(void) {\n\
	out_Color = texture(overlay, frag_TexCoord);\n\
\n\
	//lighting\n\
	vec4 light_factor = light(cam_mat, quad_normal, frag_pos);\n\
	out_Color *= mix(vec4(1.0), light_factor, lit);\n\
}\n\
";
const GLchar* FragShader_quad = "#version 430\n\
#define YR_ACCURACY 4096.0f\n\
#define UV_PER_METER (1.0f/0.256f)\n\
#define QUAD_BG_TILE 64\n\
#extension GL_ARB_bindless_texture : require\n\
\n\
struct ssbo_quad\n\
{\n\
	ivec4		v[3];\n\
	vec4		normal;\n\
	uvec2		_pad0;\n\
	vec2		uv_back[2];\n\
	vec2		uv_draw;\n\
	vec2		size;\n\
	uint		color;\n\
	uint		twtbg; //tile width, texture bg, _pad, _pad\n\
	uint		id;\n\
	uint		flags;\n\
	uvec2		_pad3;\n\
};\n\
\n\
flat in int instance;\n\
smooth in vec2 frag_uv;\n\
smooth in vec4 frag_pos;\n\
\n\
layout(std430, binding=0) buffer QuadData\n\
{\n\
	ssbo_quad	quad[8192];\n\
	uint		texbase[8192];\n\
	uvec2		texbuf[];\n\
};\n\
layout(std430, binding=1) buffer Backgrounds\n\
{\n\
	uvec2	backgrounds[];\n\
};\n\
\n\
out vec4 out_Color;\n\
\n\
uniform mat4 cam_mat;\n\
#define MAX_LIGHTS 2\n\
#define MAX_TRACKED 2\n\
#define TRACKED_SHADOW_SIZE 0.3\n\
\n\
uniform ivec2 light_screensize;\n\
uniform vec4 light_dir[MAX_LIGHTS];\n\
uniform vec4 light_color[MAX_LIGHTS];\n\
uniform vec4 light_trackedpos[MAX_TRACKED];\n\
uniform uvec2 light_map[MAX_LIGHTS * MAX_TRACKED];\n\
\n\
vec3 viewdir_from_screenpos(mat4 mat)\n\
{\n\
	mat4 invmat = inverse(cam_mat);\n\
	vec2 screenpos = gl_FragCoord.xy / vec2(light_screensize/2) - 1;\n\
	vec4 origin = invmat * vec4(screenpos, 0.25, 1.0);\n\
	vec4 lookat = invmat * vec4(screenpos, 0.5, 1.0);\n\
	origin = origin/origin.w;\n\
	lookat = lookat/lookat.w;\n\
	return normalize((lookat - origin).xyz);\n\
}\n\
\n\
float singlelight(vec3 e, vec3 n, vec3 l)\n\
{\n\
	vec3 h = normalize(e+l);\n\
	float diff = 0.2 / 3.1415926535897932;\n\
	float spec = 0.5 * (2+1)/(3.1415926535897932);\n\
	float facing = ((dot(n,l) * dot(n,e)) > 0.0) ? 1.0 : 0.0;\n\
	float intensity = diff + spec * pow(dot(n,h),2);\n\
	return facing * abs(dot(n,l)) * intensity;\n\
}\n\
\n\
float shadow(vec4 pos, mat4 mat, uvec2 map)\n\
{\n\
	vec4 lpos = mat * pos;\n\
	float obstruct = texture(sampler2D(map), lpos.xy/2 + 0.5).r;\n\
	float depth = lpos.z/2 + 0.5;\n\
	if(obstruct >= 1.0) obstruct = depth;\n\
	return (depth <= obstruct) ? 1.0 : 0.0;\n\
}\n\
\n\
float rand(vec4 pos, float t) {\n\
  return fract(sin(dot(pos.xy + vec2(pos.z,t) ,vec2(12.9898,78.233))) * 43758.5453);\n\
}\n\
\n\
vec4 light(mat4 viewmat, vec3 n, vec4 pos)\n\
{\n\
	vec3 base = vec3(0.3);\n\
	vec3 e = -viewdir_from_screenpos(viewmat);\n\
\n\
	vec3 total = base;\n\
	//unrolled: for(uint l = 0; l < MAX_LIGHTS; ++l) {\n\
\n\
	//light 0\n\
		//shadowmaps\n\
		float shadowtotal = 1.0;\n\
		mat4 mat;\n\
		mat[2] = light_dir[0];\n\
		mat[0] = vec4(normalize(cross(light_dir[0].xyz, vec3(1,0,0))), 0.0);\n\
		mat[1] = vec4(cross(mat[0].xyz, mat[2].xyz), 0.0);\n\
		mat[0] *= TRACKED_SHADOW_SIZE;\n\
		mat[1] *= TRACKED_SHADOW_SIZE;\n\
		mat[2] *= 2*TRACKED_SHADOW_SIZE;\n\
		// unrolled: for(uint t = 0; t < MAX_TRACKED; ++t) {\n\
		mat[3] = light_trackedpos[0] - TRACKED_SHADOW_SIZE * light_dir[0];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[0]);\n\
		mat[3] = light_trackedpos[1] - TRACKED_SHADOW_SIZE * light_dir[0];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[1]);\n\
		//light\n\
		total += light_color[0].rgb * shadowtotal * singlelight(e, n, -light_dir[0].xyz);\n\
\n\
	//light 1\n\
		//shadowmaps\n\
		shadowtotal = 1.0;\n\
		mat[2] = light_dir[1];\n\
		mat[0] = vec4(normalize(cross(light_dir[1].xyz, vec3(1,0,0))), 0.0);\n\
		mat[1] = vec4(cross(mat[0].xyz, mat[2].xyz), 0.0);\n\
		mat[0] *= TRACKED_SHADOW_SIZE;\n\
		mat[1] *= TRACKED_SHADOW_SIZE;\n\
		mat[2] *= 2*TRACKED_SHADOW_SIZE;\n\
		// unrolled: for(uint t = 0; t < MAX_TRACKED; ++t) {\n\
		mat[3] = light_trackedpos[0] - TRACKED_SHADOW_SIZE * light_dir[1];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[2]);\n\
		mat[3] = light_trackedpos[1] - TRACKED_SHADOW_SIZE * light_dir[1];\n\
		shadowtotal *= shadow(pos, inverse(mat), light_map[3]);\n\
		//light\n\
		total += light_color[1].rgb * shadowtotal * singlelight(e, n, -light_dir[1].xyz);\n\
\n\
	//dither to reduce banding\n\
	total += vec3(rand(pos,viewmat[0][1]))/255;\n\
	return vec4(total, 1.0);\n\
}\n\
\n\
vec4 light_noshadow(mat4 viewmat, vec3 n)\n\
{\n\
	vec3 base = vec3(0.3);\n\
	vec3 e = -viewdir_from_screenpos(viewmat);\n\
\n\
	vec3 total = base;\n\
	for(uint l = 0; l < MAX_LIGHTS; ++l) {\n\
		//light\n\
		total += light_color[l].rgb * singlelight(e, n, -light_dir[l].xyz);\n\
	}\n\
	return vec4(total, 1.0);\n\
}\n\
\n\
void main(void)\n\
{\n\
	//base color\n\
	out_Color = vec4(unpackUnorm4x8(quad[instance].color).rgb, 1.0);\n\
\n\
	vec2 hor_grad = dFdx(frag_uv);\n\
	vec2 ver_grad = dFdy(frag_uv);\n\
\n\
	//unpack packed field\n\
	uvec4 pvals = uvec4(unpackUnorm4x8(quad[instance].twtbg) * 255);\n\
\n\
	//background layer\n\
	vec2 bgdim = quad[instance].uv_back[1] - quad[instance].uv_back[0];\n\
	vec2 bg_uv = quad[instance].uv_back[0] + frag_uv * bgdim;\n\
	vec2 horgrad_bg = hor_grad * bgdim;\n\
	vec2 vergrad_bg = ver_grad * bgdim;\n\
	uvec2 bghandle = backgrounds[pvals[1]];\n\
	vec4 bg_color = vec4(0.0);\n\
	if(bghandle != uvec2(0,0)) bg_color = textureGrad(sampler2D(bghandle), fract(bg_uv), horgrad_bg, vergrad_bg);\n\
	if((int(quad[instance].flags) & QUAD_BG_TILE)==0) {\n\
		if(any(lessThan(bg_uv, vec2(0.0))) || any(greaterThanEqual(bg_uv, vec2(1.0))))\n\
			bg_color = vec4(0.0);\n\
	}\n\
	out_Color = (out_Color * (1.0 - bg_color.a)) + bg_color;\n\
\n\
	//draw layer\n\
	vec2 drawdim = quad[instance].size * UV_PER_METER;\n\
	vec2 draw_uv = quad[instance].uv_draw + frag_uv * drawdim;\n\
	vec2 horgrad_draw = hor_grad * drawdim;\n\
	vec2 vergrad_draw = ver_grad * drawdim;\n\
	ivec2 draw_tile = min(ivec2(7,7), ivec2(draw_uv));\n\
\n\
	uint tex_idx = texbase[instance];\n\
	tex_idx += draw_tile.y * int(pvals[0]);\n\
	tex_idx += draw_tile.x;\n\
\n\
	vec4 draw_color = vec4(0.0);\n\
	if(texbuf[tex_idx] != uvec2(0,0)) draw_color = textureGrad(sampler2D(texbuf[tex_idx]), fract(draw_uv), horgrad_draw, vergrad_draw);\n\
	out_Color = (out_Color * (1.0 - draw_color.a)) + draw_color;\n\
\n\
	//lighting\n\
	vec4 light_factor = light(cam_mat, quad[instance].normal.xyz, frag_pos);\n\
	out_Color *= light_factor;\n\
}\n\
";
const GLchar* FragShader_sky = "#version 430\n\
#define PI 3.1415926535897932\n\
uniform mat4 cam_mat;\n\
uniform sampler2D skytex;\n\
uniform ivec2 light_screensize;\n\
\n\
out vec4 out_Color;\n\
\n\
void main(void)\n\
{\n\
	//modified viewdir_from_screenpos\n\
	mat4 invmat = inverse(cam_mat);\n\
	vec2 screenpos = gl_FragCoord.xy / vec2(light_screensize/2) - 1;\n\
	vec4 origin = invmat * vec4(screenpos, 0.0, 1.0);\n\
	vec4 lookat = invmat * vec4(screenpos, 1.0, 1.0);\n\
	origin = origin/origin.w;\n\
	lookat = lookat/lookat.w;\n\
	vec3 viewdir = normalize((lookat - origin).xyz);\n\
\n\
	//calculate sky coordinate\n\
	vec2 skycoord = vec2(	atan(viewdir.y, viewdir.x) 	/ (2*PI)	+ 0.5,\n\
							-asin(viewdir.z) 			/ PI 		+ 0.5);\n\
	//texture lookups\n\
	vec2 skyGradX = dFdx(skycoord);\n\
	vec2 skyGradY = dFdy(skycoord);\n\
	if(length(skyGradX) > 0.99) skyGradX = vec2(0.0);\n\
	if(length(skyGradY) > 0.99) skyGradY = vec2(0.0);\n\
	vec4 skycolor = textureGrad(skytex, skycoord, skyGradX, skyGradY);\n\
	out_Color = skycolor;\n\
}\n\
";
const GLchar* FragShader_tparc = "#version 430\n\
\n\
uniform float max_t;\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	out_Color = (max_t > 0.0)\n\
		? vec4(0.0726, 0.5, 0.4549, 0.5)\n\
		: vec4(0.4274, 0.0, 0.0451, 0.5);\n\
}\n\
";
const GLchar* FragShader_tpfloor = "#version 430\n\
\n\
uniform sampler2D tex_Sprite;\n\
smooth in vec2 frag_TexCoord;\n\
\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	out_Color = texture(tex_Sprite, frag_TexCoord);\n\
}\n\
";
const GLchar* FragShader_trackedoverlay_render = "#version 430\n\
\n\
uniform sampler2D overlay;\n\
\n\
smooth in vec2 frag_TexCoord;\n\
out vec4 out_Color;\n\
\n\
void main(void) {\n\
	vec2 c = frag_TexCoord.xy * 2 - 1.0;\n\
	vec4 bg = vec4(0.0);\n\
	bg.a = 0.5 - 0.5*smoothstep(0.90, 1.0, length(c));\n\
	vec4 tc = texture(overlay, frag_TexCoord);\n\
	out_Color = tc + (1-tc.a)*bg;\n\
}\n\
";
const GLchar* FragShader_ui_elem = "#version 430\n\
#extension GL_ARB_bindless_texture : require\n\
\n\
struct ssbo_ui\n\
{\n\
	vec2 size;\n\
	vec2 pos;\n\
	uint fg;\n\
	uint bg;\n\
	uvec2 tex;\n\
};\n\
\n\
layout(std430, binding=0) buffer Elems\n\
{\n\
	ssbo_ui elems[];\n\
};\n\
smooth in vec2 uv;\n\
flat in int inst;\n\
out vec4 out_Color;\n\
\n\
void main(void)\n\
{\n\
	vec4 c = unpackUnorm4x8(elems[inst].fg) * texture(sampler2D(elems[inst].tex), uv);\n\
	out_Color = fma(vec4(1.0 - c.a), unpackUnorm4x8(elems[inst].bg), c);\n\
}\n\
";
const GLchar* FragShader_ui_screen = "#version 430\n\
\n\
uniform sampler2D tex;\n\
uniform vec2 ui_size;\n\
uniform vec2 ui_off;\n\
out vec4 out_Color;\n\
\n\
void main(void)\n\
{\n\
	vec2 pos = (gl_FragCoord.xy - ui_off)/ui_size;\n\
	out_Color = texture(tex, pos);\n\
}\n\
";
const GLchar* VtxShader_barstat = "#version 430\n\
\n\
uniform mat4 cam_mat;\n\
uniform float value;\n\
uniform int row;\n\
layout(location=0) in vec3 vtx_Pos;\n\
\n\
void main(void) {\n\
	vec3 lo = vec3(-0.075,				0.06 - row*0.01, -0.2);\n\
	vec3 hi = vec3(-0.075 + value*0.15,	0.05 - row*0.01, -0.2);\n\
	vec4 pos = vec4(mix(lo,hi,vtx_Pos),1.0);\n\
	gl_Position = cam_mat * pos;\n\
}\n\
";
const GLchar* VtxShader_beam = "#version 430\n\
\n\
uniform mat4 cam_mat;\n\
uniform vec4 start;\n\
uniform vec4 endoff;\n\
\n\
layout(location=0) in vec4 vtx_Pos;\n\
\n\
void main(void) {\n\
	vec3 dir = normalize(endoff.xyz);\n\
	vec3 foo = dir;\n\
	if(abs(foo.x) > abs(foo.y))	foo.y = 1.0f;\n\
	else						foo.x = 1.0f;\n\
	foo = normalize(foo);\n\
\n\
	mat4 beam_mat = mat4(0.0f);\n\
	beam_mat[0] = vec4(normalize(cross(foo, dir)), 0.0f);\n\
	beam_mat[1] = vec4(cross(dir, beam_mat[0].xyz), 0.0f);\n\
	beam_mat[2] = vec4(endoff.xyz, 0.0f);\n\
	beam_mat[3] = vec4(start.xyz, 1.0f);\n\
\n\
	gl_Position = cam_mat * beam_mat * vtx_Pos;\n\
}\n\
";
const GLchar* VtxShader_beamcap = "#version 430\n\
#define YR_ACCURACY 4096.0f\n\
\n\
uniform mat4 cam_mat;\n\
uniform vec4 pos;\n\
uniform vec4 normal;\n\
layout(location=0) in vec3 vtx_Pos;\n\
smooth out vec2 frag_TexCoord;\n\
\n\
void main(void) {\n\
	vec4 vtx = vec4(vtx_Pos.xy * 2.0 - 1.0, 0.0f, 1.0f);\n\
	frag_TexCoord = vtx_Pos.xy;\n\
\n\
	vec3 foo = normal.xyz;\n\
	if(abs(foo.x) > abs(foo.y))	foo.y = 1.0f;\n\
	else						foo.x = 1.0f;\n\
	foo = normalize(foo);\n\
\n\
	mat4 cap_mat = mat4(0.0f);\n\
	cap_mat[0] = vec4(normalize(cross(foo, normal.xyz)), 0.0f);\n\
	cap_mat[1] = vec4(cross(normal.xyz, cap_mat[0].xyz), 0.0f);\n\
	cap_mat[2] = vec4(normal.xyz, 0.0f);\n\
	cap_mat[3] = vec4(pos.xyz + 0.002 * normal.xyz, 1.0f);\n\
\n\
	vtx.x *= 0.03f;\n\
	vtx.y *= 0.03f;\n\
	gl_Position = cam_mat * cap_mat * vtx;\n\
}\n\
";
const GLchar* VtxShader_colorpick_lum = "#version 430\n\
\n\
uniform mat4 cam_mat;\n\
uniform mat4 pick_mat;\n\
uniform vec4 color_gbl;\n\
layout(location=0) in vec3 vtx_Pos;\n\
smooth out float lum;\n\
\n\
void main(void) {\n\
	vec4 pos = vec4(vtx_Pos, 1.0);\n\
	pos.x *= 0.04;\n\
	pos.x += 0.26;\n\
	pos.y *= 0.25 * 0.8660254037844386;\n\
	gl_Position = cam_mat * pick_mat * pos;\n\
\n\
	lum = 1.1 * vtx_Pos.y;\n\
}\n\
";
const GLchar* VtxShader_colorpick_rgb = "#version 430\n\
\n\
uniform mat4 cam_mat;\n\
uniform mat4 pick_mat;\n\
layout(location=0) in vec3 vtx_Pos;\n\
smooth out vec4 bary;\n\
\n\
void main(void) {\n\
	vec4 pos = vec4(vtx_Pos, 1.0);\n\
	pos.x *= 0.25;\n\
	pos.x -= 0.125 * (1.0-pos.y);\n\
	pos.y *= 0.25 * 0.8660254037844386;\n\
	gl_Position = cam_mat * pick_mat * pos;\n\
	bary = vec4((1.0f - vtx_Pos.x) * vtx_Pos.y, vtx_Pos.x * vtx_Pos.y, (1.0 - vtx_Pos.y), 1.0f);\n\
}\n\
";
const GLchar* VtxShader_floor = "#version 430\n\
#define RANGE 2048.0\n\
\n\
uniform mat4 cam_mat;\n\
layout(location=0) in vec3 vtx_Pos;\n\
smooth out vec4 frag_Pos;\n\
\n\
void main(void) {\n\
	vec4 vtx = vec4(mix(vec2(-RANGE/4), vec2(RANGE/4), vtx_Pos.xy), -0.0039, 1.0);\n\
	frag_Pos = vtx;\n\
	gl_Position = cam_mat * vtx;\n\
}\n\
";
const GLchar* VtxShader_fontrender = "#version 430\n\
\n\
uniform vec2 pos;\n\
uniform vec4 box;\n\
uniform vec2 outsize;\n\
uniform vec2 charsize;\n\
\n\
layout(location=0) in vec2 vtx_Pos;\n\
smooth out vec2 uv;\n\
\n\
void main(void) {\n\
	//vertex position\n\
	vec2 foo = pos + mix(box.xy, box.zw, vtx_Pos);\n\
	foo = floor(foo)/outsize; //snap to pixel, then partially convert to viewport space\n\
	foo = foo * 2 - 1.0; //finish conversion to vp space\n\
	gl_Position = vec4(foo, 0.0, 1.0);\n\
	//texture coordinates\n\
	uv = vtx_Pos * (box.zw - box.xy)/charsize;\n\
}\n\
";
const GLchar* VtxShader_model = "#version 430\n\
#define YR_ACCURACY 4096.0f\n\
\n\
uniform mat4 cam_mat;\n\
uniform ivec4 cam_pos;\n\
uniform mat4 mdl_mat;\n\
uniform ivec4 mdl_pos;\n\
\n\
layout(location=0) in vec3 vtx_Pos;\n\
layout(location=1) in vec3 vtx_Normal;\n\
layout(location=2) in vec2 vtx_TexCoord;\n\
\n\
smooth out vec3 frag_Normal;\n\
smooth out vec2 frag_TexCoord;\n\
\n\
void main(void) {\n\
	vec4 pos_off = vec4(mdl_pos - cam_pos)/YR_ACCURACY;\n\
	gl_Position = cam_mat * ((mdl_mat * vec4(vtx_Pos,1.0f)) + pos_off);\n\
	frag_TexCoord = vtx_TexCoord;\n\
	frag_Normal = (mdl_mat * vec4(vtx_Normal, 0.0f)).xyz;\n\
}\n\
";
const GLchar* VtxShader_modelshadow = "#version 430\n\
#define YR_ACCURACY 4096.0f\n\
\n\
uniform mat4 light_mat;\n\
uniform mat4 mdl_mat;\n\
\n\
layout(location=0) in vec3 vtx_Pos;\n\
layout(location=1) in vec3 vtx_Normal;\n\
layout(location=2) in vec2 vtx_TexCoord;\n\
\n\
void main(void) {\n\
	gl_Position = light_mat * (mdl_mat * vec4(vtx_Pos,1.0f));\n\
}\n\
";
const GLchar* VtxShader_overlay_draw = "#version 430\n\
\n\
uniform vec4 pos;\n\
layout(location=0) in vec3 vtx_Pos;\n\
smooth out vec2 uv;\n\
\n\
void main(void) {\n\
	vec2 lo = (pos.xy/4.0f) - 1.0f;\n\
	vec2 hi = (pos.zw/4.0f) - 1.0f;\n\
	gl_Position = vec4(mix(lo, hi, vtx_Pos.xy), 0.0f,1.0f);\n\
	uv = vtx_Pos.xy;\n\
}\n\
";
const GLchar* VtxShader_overlay_erase = "#version 430\n\
\n\
uniform float depth;\n\
layout(location=0) in vec4 vtx_Pos;\n\
\n\
void main(void) {\n\
	gl_Position = vec4(vtx_Pos.xy/4 - 1.0, 2 * vtx_Pos.z / depth + 1.0, 1.0);\n\
}\n\
";
const GLchar* VtxShader_overlay_render = "#version 430\n\
#define YR_ACCURACY 4096.0f\n\
\n\
uniform mat4 cam_mat;\n\
uniform ivec4 cam_pos;\n\
layout(location=0) in ivec3 vtx_Pos;\n\
layout(location=1) in vec2 vtx_TexCoord;\n\
smooth out vec2 frag_TexCoord;\n\
smooth out vec4 frag_pos;\n\
\n\
void main(void) {\n\
	frag_pos = (vec4(ivec4(vtx_Pos,YR_ACCURACY) - cam_pos)/YR_ACCURACY);\n\
	gl_Position = cam_mat * frag_pos;\n\
	frag_TexCoord = vtx_TexCoord / 8;\n\
}\n\
";
const GLchar* VtxShader_quad = "#version 430\n\
#define YR_ACCURACY 4096.0f\n\
#define UV_PER_METER (1.0f/0.256f)\n\
#extension GL_ARB_bindless_texture : require\n\
\n\
struct ssbo_quad\n\
{\n\
	ivec4		v[3];\n\
	vec4		normal;\n\
	uvec2		_pad0;\n\
	vec2		uv_back[2];\n\
	vec2		uv_draw;\n\
	vec2		size;\n\
	uint		color;\n\
	uint		twtbg; //tile width, texture bg, _pad, _pad\n\
	uint		id;\n\
	uint		flags;\n\
	uvec2		_pad3;\n\
};\n\
\n\
uniform mat4 cam_mat;\n\
uniform ivec4 cam_pos;\n\
\n\
layout(location=0) in vec2 vtx_Pos;\n\
layout(std430, binding=0) buffer QuadData\n\
{\n\
	ssbo_quad	quad[8192];\n\
	uint		texbase[8192];\n\
	uvec2		texbuf[];\n\
};\n\
layout(std430, binding=1) buffer Backgrounds\n\
{\n\
	uvec2		backgrounds[];\n\
};\n\
\n\
flat out int instance;\n\
smooth out vec2 frag_uv;\n\
smooth out vec4 frag_pos;\n\
\n\
void main(void)\n\
{\n\
	instance = gl_InstanceID;\n\
	frag_uv = vtx_Pos;\n\
	ivec4 pos = quad[gl_InstanceID].v[0];\n\
	pos += int(vtx_Pos.x) * (quad[gl_InstanceID].v[1] - quad[gl_InstanceID].v[0]);\n\
	pos += int(vtx_Pos.y) * (quad[gl_InstanceID].v[2] - quad[gl_InstanceID].v[0]);\n\
	pos -= cam_pos;\n\
	frag_pos = vec4(pos)/YR_ACCURACY;\n\
	gl_Position = cam_mat * frag_pos;\n\
}\n\
";
const GLchar* VtxShader_tparc = "#version 430\n\
\n\
uniform mat4 cam_mat;\n\
uniform vec4 start;\n\
uniform vec4 initial_v;\n\
uniform float max_t;\n\
layout(location=0) in vec3 vtx_Pos;\n\
\n\
void main(void) {\n\
	float t = vtx_Pos.z * abs(max_t);\n\
	vec4 g = vec4(0.0, 0.0, 9.81, 0.0);\n\
\n\
	vec4 pos = start + t*initial_v - t*t*g;\n\
\n\
	vec3 dir = normalize((initial_v - t*g).xyz);\n\
	vec3 side = cross(initial_v.xyz, vec3(0,0,1));\n\
	if(dot(side,side)<0.0001) side = vec3(0,1,0);\n\
	side = normalize(side);\n\
	pos = pos + vec4(mat3(side, cross(side,dir), dir) * vec3(vtx_Pos.xy, 0.0), 0.0);\n\
\n\
	gl_Position = cam_mat * pos;\n\
}\n\
";
const GLchar* VtxShader_tpfloor = "#version 430\n\
\n\
uniform mat4 cam_mat;\n\
uniform vec2 dims[2];\n\
layout(location=0) in vec3 vtx_Pos;\n\
smooth out vec2 frag_TexCoord;\n\
\n\
void main(void) {\n\
	vec4 vtx = vec4(mix(dims[0], dims[1], vtx_Pos.xy), 0.0, 1.0);\n\
	frag_TexCoord = vec2(vtx_Pos.xy);\n\
\n\
	gl_Position = cam_mat * vtx;\n\
}\n\
";
const GLchar* VtxShader_trackedoverlay_draw = "#version 430\n\
\n\
uniform vec4 pos;\n\
layout(location=0) in vec3 vtx_Pos;\n\
smooth out vec2 uv;\n\
\n\
void main(void) {\n\
	vec2 lo = pos.xy;\n\
	vec2 hi = pos.zw;\n\
	gl_Position = vec4(mix(lo, hi, vtx_Pos.xy), 0.0f,1.0f);\n\
	uv = vtx_Pos.xy;\n\
}\n\
";
const GLchar* VtxShader_trackedoverlay_render = "#version 430\n\
#define YR_ACCURACY 4096.0f\n\
\n\
uniform mat4 cam_mat;\n\
uniform mat4 tracked_mat;\n\
layout(location=0) in vec3 vtx_Pos;\n\
smooth out vec2 frag_TexCoord;\n\
\n\
void main(void) {\n\
	vec4 pos = vec4(\n\
		vtx_Pos.x * 0.04 - 0.02,\n\
		vtx_Pos.y * 0.004 - 0.002 + 0.01,\n\
		vtx_Pos.y * -0.04 + 0.02 + 0.049,\n\
		1.0);\n\
	gl_Position = cam_mat * tracked_mat * pos;\n\
	frag_TexCoord = vtx_Pos.xy;\n\
}\n\
";
const GLchar* VtxShader_ui_elem = "#version 430\n\
\n\
struct ssbo_ui\n\
{\n\
	vec2 size;\n\
	vec2 pos;\n\
	uint fg;\n\
	uint bg;\n\
	uvec2 tex;\n\
};\n\
\n\
layout(std430, binding=0) buffer Elems\n\
{\n\
	ssbo_ui elems[];\n\
};\n\
uniform float ar;\n\
layout(location=0) in vec2 vtx_Pos;\n\
smooth out vec2 uv;\n\
flat out int inst;\n\
\n\
void main(void) {\n\
	inst = gl_InstanceID;\n\
	vec2 foo = (elems[inst].pos + vtx_Pos * elems[inst].size) * vec2(0.01, ar/100);\n\
	foo.y = 1.0 - foo.y;\n\
	foo = foo * 2 - 1.0;\n\
	gl_Position = vec4(foo, 0.0, 1.0);\n\
	uv = vtx_Pos;\n\
}\n\
";
const GLchar* VtxShader_unit2screen = "#version 430\n\
\n\
layout(location=0) in vec2 vtx_Pos;\n\
\n\
void main(void) {\n\
	gl_Position = vec4(vtx_Pos * 2.0 - 1.0, -1.0, 1.0);\n\
}\n\
";
