#include "stack32.h"
#include "sys_log.h"
#include "platform.h"
#include <stdlib.h>

struct _yrtag_stack32
{
	uint32_t* data;
	size_t size;
	size_t top;
};

yrStack32* yrStack32_create(size_t size)
{
	yrStack32* out = malloc(sizeof(yrStack32));
	if(!out) { yrLog(0, "Out of memory"); return NULL; }

	out->size = size;
	out->top = 0;
	out->data = malloc(size * sizeof(uint32_t));
	if(!out->data) {
		free(out);
		yrLog(0, "Out of memory");
		return NULL;
	}
	return out;
}

void yrStack32_destroy(yrStack32* s)
{
	if(!s) return;
	free(s->data);
	free(s);
}

uint32_t*	yrStack32_get_ptr(yrStack32* s) {return s->data;}
size_t		yrStack32_get_size(yrStack32* s) {return s->size;}
size_t		yrStack32_get_top(yrStack32* s) {return s->top;}
void		yrStack32_set_top(yrStack32* s, size_t t)  {s->top = t;}

int yrStack32_is_empty(yrStack32* s)
{
	return (s->top == 0);
}

uint32_t yrStack32_pop(yrStack32* s)
{
	YR_ASSERT(s->top);
	s->top -= 1;
	return s->data[s->top];
}

void yrStack32_push(yrStack32* s, uint32_t v)
{
	YR_ASSERT(s->top != s->size);
	s->data[s->top] = v;
	s->top += 1;
}
