#pragma once
#include "vecmath.h"
#include "sys_render.h"

enum tool_mode {tmPen, tmTeleport, tmCreate, tmMove, tmDelete, tmCopy, tmResize, tmColor, tmBackground, tmUndo, tm_end};//tmHotkeys};
struct _tracehit
{
	vec4i pos;
	yrQuad* q;
	float hitcoord[2];
	float dist;
};
typedef struct _tracehit tracehit;

typedef void	(*func_tool_shutdown)		(void);
typedef void	(*func_tool_settrackedid)	(uint32_t tracked_id, unsigned toolidx);
typedef void	(*func_tool_tick)			(void);
typedef int		(*func_tool_canfreeze)		(void);
typedef void	(*func_tool_forceidle)		(void);
typedef int		(*func_tool_getpokepos)		(vec4f* pos, vec4f* dir, float* len);
typedef void	(*func_tool_renderwindow)	(void);
typedef void	(*func_tool_poke)			(void);
typedef int		(*func_tool_init)			(func_tool_shutdown*,
											 func_tool_settrackedid*,
											 func_tool_tick*,
											 func_tool_canfreeze*,
											 func_tool_forceidle*,
											 func_tool_getpokepos*,
											 func_tool_renderwindow*,
											 func_tool_poke*);
static void nullfunc(void) {;}

void yrInteraction_notifycontroller(uint32_t tracked_id, int on_off);
void yrInteraction_changemode(unsigned toolidx, enum tool_mode newmode);

yrColor			yrInteraction_getpencolor(void);
yrColor			yrInteraction_getbgcolor(void);
unsigned char	yrInteraction_getbgimage(void);
yrColor			yrInteraction_getsavedcolor(size_t index);
void yrInteraction_setpencolor(yrColor c);
void yrInteraction_setbgcolor(yrColor c);
void yrInteraction_setbgimage(int image);
void yrInteraction_setsavedcolor(size_t index, yrColor c);
size_t yrInteraction_getpokepos(vec4f* pickpos, vec4f* pickdir, float* picklen, size_t start);

tracehit yrInteraction_trace(vec4i origin, vec4f dir, float min_dist, float max_dist);
yrQuad* yrInteraction_erasetrace(vec4i* corners, vec4f dir, float erase_depth, float erase_radius);
tracehit yrInteraction_intersect(yrQuad* q, vec4i origin, vec4f dir);