#pragma once
#include <stdint.h>

void _yrLogInternal(int level, uint32_t color, uint64_t duration, const char* file, int line, const char* function, const char* format, ...);

#define yrLog(level, format, ...)						do { _yrLogInternal(level, 0ul,		0,			__FILE__, __LINE__, __func__, format, ##__VA_ARGS__); } while(0)
#define yrLogAlert(level, color, duration, format, ...)	do { _yrLogInternal(level, color,	duration,	__FILE__, __LINE__, __func__, format, ##__VA_ARGS__); } while(0)