#include "system.h"
#include "platform.h"
#include "imgload.h"

static int yrPlatform_init(void* loadtoken)	{ return yrImgLoad_init(); }
static int yrPlatform_tick(void)			{ return yr_platform_update(); }
static int yrPlatform_save(void* savetoken, void* saveevent, int* savefailed) { yrEvent_set(saveevent, 1); return 0; }
static int yrPlatform_canfreeze(void)		{ return 1; }
static int yrPlatform_freeze(void)			{ return 0; }
static int yrPlatform_unfreeze(void)		{ return 0; }
static int yrPlatform_shutdown(void)		{ yrImgLoad_shutdown(); return 0; }

void yrPlatform_reg(void)
{
	yrSystem_register(sysPlatform,
					  yrPlatform_init,
					  yrPlatform_tick,
					  yrPlatform_save,
					  yrPlatform_canfreeze,
					  yrPlatform_freeze,
					  yrPlatform_unfreeze,
					  yrPlatform_shutdown,
					  (1<<sysLog));
}
