#pragma once
#include "sys_quadstore.h"
#include "vecmath.h"

typedef void* yrModel;
typedef void* yrTexture;
static inline float yrColor_red(yrColor c)		{ return (float)(c >>  0 & 0xFF)/255.0f; }
static inline float yrColor_green(yrColor c)	{ return (float)(c >>  8 & 0xFF)/255.0f; }
static inline float yrColor_blue(yrColor c)		{ return (float)(c >> 16 & 0xFF)/255.0f; }
static inline float yrColor_alpha(yrColor c)	{ return (float)(c >> 24 & 0xFF)/255.0f; }
static inline yrColor yrColor_create(float r, float g, float b, float a)
{
	yrColor out = 0;
#pragma push_macro("sat")
#define sat(v) (((v)<=255.0f)?(((v)>=0.0f)?(v):0.0f):255.0f)
	out |= (uint32_t)(sat(r * 255.f + 0.5f)) <<  0;
	out |= (uint32_t)(sat(g * 255.f + 0.5f)) <<  8;
	out |= (uint32_t)(sat(b * 255.f + 0.5f)) <<  16;
	out |= (uint32_t)(sat(a * 255.f + 0.5f)) <<  24;
#pragma pop_macro("sat")
	return out;
}

#define OVERLAY_EDIT 0
#define OVERLAY_CREATE 1
#define OVERLAY_COLORPICK 2
#define OVERLAY_BACKGROUND 3
#define MAX_OVERLAYS 4

enum yrBarStat { bsTimeOther, bsTimeInteraction, bsTimeRender, bsTimeQuads, bsBlankReserve, bsImporantQueue, bsFullAvailable, bsMipsAvailable, bsIdxAvailable, bs_end };

yrTexture	yrTexture_loadfile(const char* file);
yrTexture	yrTexture_loadmem(size_t len, void* buf);
void		yrTexture_unload(yrTexture tex);
yrModel	yrModel_load(const char* file);
void	yrModel_unload(yrModel mdl);
void	yrModel_render(yrModel mdl, yrTexture tex, const mat4f world_from_model, vec4i pos, yrColor clr, uint32_t tracked_id);

void yrRenderOverlay_clear(unsigned idx);
void yrRenderOverlay_draw(unsigned idx, yrTexture tex, float x0, float y0, float x1, float y1, yrColor clr);
void yrRenderOverlay_mask_erase(unsigned idx, float depth, vec4f* v, yrColor bgcolor);
void yrRenderOverlay_apply(unsigned idx, yrQuad* q, uint64_t changed, int erase);
void yrRenderOverlay_render(unsigned idx, yrQuad* q, int lit);

void yrRenderTrackedOverlay_clear(unsigned idx);
void yrRenderTrackedOverlay_draw(unsigned idx, yrTexture tex, float x0, float y0, float x1, float y1, yrColor clr);
void yrRenderTrackedOverlay_set(unsigned idx, uint32_t tracked_id);
void yrRenderTrackedOverlay_render(unsigned idx);

void yrRender_set_trackedshadow(unsigned idx, uint32_t tracked_id);
void yrRender_beam(unsigned idx, vec4f start, vec4f dir, vec4f endnormal, float dist, yrColor clr);
void yrRender_teleport(vec4f start, vec4f initial_v, float max_t, vec4f hmd_off);
void yrRender_colorpick(mat4f m, float rg, float yb, float lum);
size_t yrRender_get_bgcount(void);
int yrRender_get_bgdata(size_t idx, yrTexture* tex, size_t* w, size_t* h);
unsigned char yrRender_bg_from_id(uint32_t id);
uint32_t yrRender_bg_to_id(unsigned char idx);
unsigned yrRender_mirrortex(void);

void yrRender_barstat(enum yrBarStat id, float value);