#ifdef _ENABLE_STEAMWORKS
#pragma comment(lib, "steam_api64.lib")
#include <steam/steam_api.h>
#endif

extern "C" {
#include "system.h"
#include "platform.h"
#include "sys_log.h"
}


extern "C" static int yrSteam_init(void* loadtoken);
extern "C" static int yrSteam_tick(void) {return 0;}
extern "C" static int yrSteam_save(void* savetoken, void* saveevent, int* savefailed) { yrEvent_set(saveevent, 1); return 0; }
extern "C" static int yrSteam_canfreeze(void) {return 1;}
extern "C" static int yrSteam_freeze(void) {return 0;}
extern "C" static int yrSteam_unfreeze(void) {return 0;}
extern "C" static int yrSteam_shutdown(void);

extern "C" void yrSteam_reg(void)
{
	yrSystem_register(sysSteam,
					  yrSteam_init,
					  yrSteam_tick,
					  yrSteam_save,
					  yrSteam_canfreeze,
					  yrSteam_freeze,
					  yrSteam_unfreeze,
					  yrSteam_shutdown,
					  (1<<sysLog)|(1<<sysPlatform));
}

/************
* Static vars
*************/
static int steam_api = 0;

/*****************
* Steam debug func
******************/
extern "C" void __cdecl SteamAPIDebugTextHook( int nSeverity, const char *pchDebugText )
{
	// if you're running in the debugger, only warnings (nSeverity >= 1) will be sent
	// if you add -debug_steamapi to the command-line, a lot of extra informational messages will also be sent
	yrLog(0, "Steam Debug (%i): %s", nSeverity, pchDebugText);

	if ( nSeverity >= 1 )
	{
		// place to set a breakpoint for catching API errors
		int x = 3;
		x = x;
	}
}

/****************************************
* System functions (init, tick, shutdown)
*****************************************/
extern "C" static int yrSteam_init(void* loadtoken)
{
#ifdef _ENABLE_STEAMWORKS
		//launch steam if necessary
	#ifdef _DEBUG
		uint32_t my_appid = 0;
	#else
		uint32_t my_appid = 000000ul;
	#endif
		if(SteamAPI_RestartAppIfNecessary(my_appid)) {
			yrLog(0, "Restarting: Steam must be running to launch this application.");
			return 1;
		}

		//init api
		if(SteamAPI_Init());
		else {
			yr_msgbox("Steam must be running to launch this application.");
			return 1;
		}
		SteamClient()->SetWarningMessageHook(&SteamAPIDebugTextHook);
		steam_api = 1;

		return 0;
#else
	return 0;
#endif
}

extern "C" static int yrSteam_shutdown(void)
{
#ifdef _ENABLE_STEAMWORKS
	if(steam_api) SteamAPI_Shutdown();
	steam_api = 0;
	return 0;
#else
	return 0;
#endif
}
