#pragma once
#include "sys_vr.h"
#include "openvr_capi.h"

void					ovrSystem_GetRecommendedRenderTargetSize(uint32_t* width, uint32_t* height);
struct HmdMatrix44_t	ovrSystem_GetProjectionMatrix(EVREye eEye, float fNearZ, float fFarZ);
struct HmdMatrix34_t	ovrSystem_GetEyeToHeadTransform(EVREye eEye);
int						ovrSystem_GetControllerState(TrackedDeviceIndex_t unControllerDeviceIndex, VRControllerState_t * pControllerState);
void					ovrSystem_TriggerHapticPulse(TrackedDeviceIndex_t unControllerDeviceIndex, uint32_t unAxisId, unsigned short usDurationMicroSec);
HiddenAreaMesh_t		ovrSystem_GetHiddenAreaMesh(EVREye eEye);

EVRCompositorError		ovrCompositor_Submit(EVREye eEye, struct Texture_t * pTexture, struct VRTextureBounds_t * pBounds, EVRSubmitFlags nSubmitFlags);
void					ovrCompositor_PostPresentHandoff(void);
void					ovrCompositor_FadeToColor(float seconds, float r, float g, float b, float a);
int						ovrChaperone_GetPlayAreaSize(float * pSizeX, float * pSizeZ);
