#pragma once
#include <stdint.h>
#include "scenefile.h"

enum yrSysId { sysRender, sysVR, sysQuadStore, sysTileStore, sysInteraction, sysPlatform, sysLog, sysUndo, sysSteam, sysDesktop, sys_end };

typedef int (*yrSystem_init_func)(void* loadtoken);
typedef int (*yrSystem_save_func)(void* savetoken, void* saveevent, int* savefailed);
typedef int (*yrSystem_canfreeze_func)(void);
typedef int (*yrSystem_freeze_func)(void);
typedef int (*yrSystem_unfreeze_func)(void);
typedef int (*yrSystem_tick_func)(void);
typedef int (*yrSystem_shutdown_func)(void);

void yrSystem_register(enum yrSysId id,
					   yrSystem_init_func init,
					   yrSystem_tick_func tick,
					   yrSystem_save_func save,
					   yrSystem_canfreeze_func canfreeze,
					   yrSystem_freeze_func freeze,
					   yrSystem_unfreeze_func unfreeze,
					   yrSystem_shutdown_func shutdown,
					   unsigned int dependencies);
int yrSystem_run(size_t visible_quads, size_t tilestore_bytes, int start_vr);

void	yrSystem_vr_init(void);
void	yrSystem_vr_stop(void);
int		yrSystem_vr_state(void);
int		yrSystem_vr_fromstart(void);
int		yrSystem_reached_runlevel(void);

size_t	yrSystem_visible_quads(void);
size_t	yrSystem_get_tilestore_bytes(void);
void	yrSystem_set_tilestore_bytes(size_t b);
void*	yrSystem_scenefile(void);
void	yrSystem_set_scenefilename(const char* scenec);
const char*	yrSystem_get_scenefilename(void);
int		yrSystem_debugmode(void);
int		yrSystem_seeksys(yrReadHandle* rh, enum yrSysId sys);
int		yrSystem_initinsert(yrSceneFile* sf, yrReadHandle** rh, yrWriteHandle** wh, enum yrSysId sys);
int		yrSystem_endinsert(yrReadHandle* rh, yrWriteHandle* wh, enum yrSysId sys);
void	yrSystem_abortinsert(yrReadHandle* rh, yrWriteHandle* wh);
void	yrSystem_freezenow(void);
void	yrSystem_unfreeze(void);

//These are called during the init phase, they then call yrSystem_register() in turn.
void yrRender_reg(void);
void yrVR_reg(void);
void yrQuadStore_reg(void);
void yrTileStore_reg(void);
void yrInteraction_reg(void);
void yrPlatform_reg(void);
void yrLog_reg(void);
void yrUndo_reg(void);
void yrSteam_reg(void);
void yrDesktop_reg(void);